#set page("a4", margin: 2.7cm, numbering: "1")
#set grid(column-gutter: .5cm, inset: (bottom: 5pt))
#set text(lang: "de", size: 11.5pt)
#set table(stroke: 0.5pt)
#set text(font: "New Computer Modern")
#set par(justify: true)
#set block(spacing: 1em)

#show heading: it => box(inset: (bottom: 1em), it)
#let checkbox(checked: false) = if (checked) {$times.square$} else {$square$}
#let input(width: 1fr, name: "", body) = box(width: width, height: 1em, inset: (bottom: 2pt), baseline: 2pt, stroke: (bottom: 0.5pt),align(right, [#body #label(name)]))
#let textfield(..args, name: "", body) = block(..args)[#body #label(name)]

#v(4em)
#align(center)[
  #text(size: 24pt)[*Prüfungsfragebogen*]

  #text(size: 16pt)[der Fachschaft Mathematik]

  #v(3.5em)
  #block(width: 14cm)[
    #align(left)[
      #par(first-line-indent: (amount: 0.5em, all: true))[
        Dieser Fragebogen dient dazu, den Studierenden, die nach dir die Prüfung
        ablegen wollen, einen Einblick in den Ablauf und den Inhalt zu geben. Das
        erleichtert die Vorbereitung und reduziert die Prüfungsangst. Schreibe bitte
        deutlich und verwende einen *schwarzen Stift*, das ist kopierfreundlicher!
      ]
    ]
  ]
  #v(2.5em)
]

== Allgemeines

#grid(columns: (auto, 1fr), row-gutter: 1em,
  [
    _Welchen Studiengang/Profil studierst du?_
  ],
  input(name: "study")[
    // Hier ist Platz für deinen Kommentar.
  ],
  [
    _Wann hast du die Prüfung abgelegt (Monat/Jahr)?_
  ],
  input(name: "date")[
    // Hier ist Platz für deinen Kommentar.
  ],
)

_Was war es für eine Prüfung?_
#v(-0.5em)
#grid(columns: (auto, 1fr, 1fr), align: (left, center, left),
  [
    #checkbox(checked: false) Diplomprüfung
  ],
  [
    #checkbox(checked: false) Staatsexamensprüfung
  ],
  [
    #checkbox(checked: false) Studienbegleitende Prüfung
  ],
  [
    #checkbox(checked: false) Bachelorprüfung
  ],
  [
    #checkbox(checked: false) Masterprüfung
  ],
  [
    #checkbox(checked: false) #input(width: 1fr, name: "kind_extra")[
      // Hier ist Platz für deinen Kommentar.
    ]
  ]
) <kind>

_Wer hat die Prüfung abgenommen?_ #input(name: "examiner")[
  // Hier ist Platz für deinen Kommentar.
]

_Welche Vorlesungen wurden geprüft und bei wem hast du sie gehört?_
#textfield(height: 1em, name: "lecture")[
  // Hier ist Platz für deinen Kommentar.
]

#table(columns: (43%, 22%, 17.5%,8%,10%,6%), stroke: (x,y) => {(
  bottom: 0.5pt,
  x: if x in range(1,5) {0.5pt},
)}, rows: (auto,) + 5 * (2.5em,),
  table.header(
  [Titel der Vorlesung],[Dozent],[Wann gehört],[SWS],[ECTS],[LP]),
  [                   ],[      ],[           ],[   ],[    ],[  ],
  [                   ],[      ],[           ],[   ],[    ],[  ],
  [                   ],[      ],[           ],[   ],[    ],[  ],
  [                   ],[      ],[           ],[   ],[    ],[  ],
  [                   ],[      ],[           ],[   ],[    ],[  ],
) <attendance>

#pagebreak()

_Wie *regelmäßig* hast du die Lehrveranstaltungen besucht?
Hat sich der Besuch/Nicht- besuch in der Prüfung positiv/negativ ausgewirkt?_
#textfield(height: 1cm, name: "attendance_worth")[
  // Hier ist Platz für deinen Kommentar.
]


== Vorbereitung auf die Prüfung

_Welche *Literatur* hast du benutzt (Bücher, Skripten, Vorlesungsmitschriften)?_
#textfield(height: 2cm, name: "literature")[
  // Hier ist Platz für deinen Kommentar.
]

_Hast du dich  *alleine/zu mehreren* auf die Prüfung vorbereitet? Wie lange?
Hat es etwas gebracht?_
#textfield(height: 1cm, name: "preparation_time")[
  // Hier ist Platz für deinen Kommentar.
]

_Fanden vor der Prüfung *Absprachen* statt (Form, Inhalt ...)? Wenn ja, welche?
Wur- den sie eingehalten?_
#textfield(height: 3cm, name: "agreements")[
  // Hier ist Platz für deinen Kommentar.
]

_Welche *Tipps* zur Vorbereitung kannst du geben? (wichtige/unwichtige Teile des
Stoffs, gute Literatur, Lernstil)_
#textfield(height: 3cm, name: "preparations")[
  // Hier ist Platz für deinen Kommentar.
]

#pagebreak()

== Ablauf der Prüfung

_Schreibe bitte aus den einzelnen Gebieten möglichst viele *Fragen* auf und
hänge sie an das Protokoll an. Gib insbesondere an, wo nach Herleitung und
Beweisen gefragt wurde, wo besonders nachgehakt wurde. Schreibe wenn möglich
auch auf, worauf der Prüfer hinaus wollte. Kennzeichne bitte Fragen, die
eigentlich nicht direkt zum Stoff gehören._

_Dauer der Prüfung?_ #input(name: "exam_duration")[
  // Hier ist Platz für deinen Kommentar.
]

_Was kannst du zum *Prüfungsstil* des/der Prüfenden sagen? (Prüfungsatmosphäre,
(un)klare Fragestellungen, Fragen nach Einzelheiten oder eher größere
Zusammenhänge, gezielte Zwischenfragen oder lässt er/sie dich erzählen,
Weiterhelfen bei Unsicherhei- ten...)_
#textfield(height: 3cm, name: "examiner_behavior")[
  // Hier ist Platz für deinen Kommentar.
]

_Wurde an Stelle deines Wissens auch dein Unwissen abgeprüft?_
#[
  #h(1fr)
  #checkbox(checked: false) ja
  #h(0.8cm)
  #checkbox(checked: false) nein
] <checked_knowledge_gaps>

_Welche *Ratschläge für das Verhalten* in der Prüfung kannst du geben?_
#textfield(height: 3.5cm, name: "examinee_behavior")[
  // Hier ist Platz für deinen Kommentar.
]

== Beurteilung der Prüfung

#grid(columns: (auto, 1fr), row-gutter: 1em,
  [
    _Welche Note hast du bekommen?_
  ],
  input(name: "grade_received")[
    // Hier ist Platz für deinen Kommentar.
  ],
  [
    _Empfandest du sie als angemessen?_
  ],
  input(name: "grade_reasonable")[
    // Hier ist Platz für deinen Kommentar.
  ],
  [
    _Kannst du die Prüfenden weiterempfehlen?_
  ],
  input(name: "examiner_recommendation")[
    // Hier ist Platz für deinen Kommentar.
  ],
)

