// SPDX-FileCopyrightText: 2025 Gero Beckmann <orangerot@orangerot.dev>
//
// SPDX-License-Identifier: MIT

#let KIND = (:
  "DIPLOM":            "Diplomprüfung",
  "STAATSEXAM":        "Staatsexamensprüfung",
  "STUDIENBEGLEITEND": "Studienbegleitende Prüfung",
  "BACHELOR":          "Bachelorprüfung",
  "MASTER":            "Masterprüfung",
  "NONE":              ""
)

#let event(name: "", lecturer: "", semester: "", sws: "", ects: "", lp: "") = (
  name, lecturer, semester, sws, ects, lp
)

#let exam-report(
  study: "",                                 // Studiengang
  lecture: "",                               // Fach
  kind: KIND.NONE,                           // Prüfungsart KIND.{DIPLOM, STAATSEXAM, STUDIENBEGLEITEND, BACHELOR, MASTER}
  date: datetime(year: 0, month: 1, day: 1), // Prüfungsdatum
  examiner: "",                              // PrüferIn (Prof)
  grade_received: 0.0,                       // Note
  grade_reasonable: "",                      // War die Note angemessen?
  exam_duration: duration(minutes: 0),       // Prüfungsdauer
  checked_knowledge_gaps: none,              // Wurde Unwissen abgeprüft?
  attendance: (
    /* Titel der Vorlesung, Dozent, Wann gehört, SWS, ECTS, LP */
    event(name: "", lecturer: "", semester: "", sws: "", ects: "", lp: ""),
    event(name: "", lecturer: "", semester: "", sws: "", ects: "", lp: ""),
    event(name: "", lecturer: "", semester: "", sws: "", ects: "", lp: ""),
    event(name: "", lecturer: "", semester: "", sws: "", ects: "", lp: ""),
    event(name: "", lecturer: "", semester: "", sws: "", ects: "", lp: ""),
  ),
  attendance_worth: [
    // Wie regelmäßig hast du die Lehrveranstaltungen besucht? Hat sich der
    // Besuch/Nichtbesuch in der Prüfung positiv/negativ ausgewirkt?
  ],
  literature: [
    // Welche Literatur hast du benutzt (Bücher, Skripten, Vorlesungsmitschriften)?
  ],
  preparation_time: [
    // Hast du dich alleine/zu mehreren auf die Prüfung vorbereitet? Wie lange?
    // Hat es etwas gebracht?
  ],
  agreements: [
    // Fanden vor der Prüfung Absprachen statt (Form, Inhalt, ...)?
    // Wenn ja, welche? Wurden sie eingehalten?
  ],
  preparations: [
    // Welche Tipps zur Vorbereitung kannst du geben?
    // (wichtige/unwichtige Teile des Stoffs, gute Literatur, Lernstil)
  ],
  examiner_behavior: [
    // Was kannst du zum Prüfungsstil des/der Prüfenden sagen?
    // (Prüfungsatmosphäre, (un)klare Fragestellungen, Fragen nach Einzelheiten
    // oder eher größere Zusammenhänge, gezielte Zwischenfragen oder lässt
    // er/sie dich erzählen, Weiterhelfen bei Unsicherheiten ...)
  ],
  examiner_recommendation: (none, [
    // Kannst du die Prüfenden weiterempfehlen?
  ]),
  examinee_behavior: [
    // Welche Ratschläge für das Verhalten in der Prüfung kannst du geben?
  ],
  doc
) = [
  #let checkbox(checked: false) = if (checked) {$times.square$} else {$square$}
  #let input(width: 1fr, body) = box(width: width, height: 1em, inset: (bottom: 2pt), baseline: 2pt, stroke: (bottom: 0.5pt),align(right, body))
  #let grid_arguments(it) = {
    let g = it.fields()
    let _ = g.remove("label")
    let _ = g.remove("children")
    return g
  }

  #show <study>: study
  #show <lecture>: lecture
  #show <date>: if date.year() > 0 {date.display("[day].[month].[year]")}
  #show <examiner>: examiner
  #show <literature>: literature
  #show <preparation_time>: preparation_time
  #show <attendance_worth>: attendance_worth
  #show <agreements>: agreements
  #show <preparations>: preparations
  #show <exam_duration>: if exam_duration.minutes() > 0 [#exam_duration.minutes()]
  #show <examiner_behavior>: examiner_behavior
  #show <examinee_behavior>: examinee_behavior
  #show <grade_received>: if grade_received > 0.0 {str(grade_received+0.01).slice(0,3).replace(".",",")}
  #show <grade_reasonable>: grade_reasonable
  #show <examiner_recommendation>: examiner_recommendation.at(1)
  #show <kind>: it => grid(..grid_arguments(it),
    ..KIND.values().filter(it => it != KIND.NONE).map(exam_kind => [
      #checkbox(checked: kind == exam_kind) #exam_kind
    ]),
    [#checkbox(checked: kind not in KIND.values() and kind != "")
      #input(width: 1fr)[ #if kind not in KIND.values() [#kind] ]
    ]
  )
  #show <attendance>: it => table(..grid_arguments(it),
    ..it.fields().children.at(0).children,
    ..(attendance + 5*(event(),)).slice(0,5).flatten()
  )
  #show <checked_knowledge_gaps>: [
    #h(1fr)
    #checkbox(checked: checked_knowledge_gaps == true) ja
    #h(0.8cm)
    #checkbox(checked: checked_knowledge_gaps == false) nein
  ]

  #include "muendliche-pruefung-mathematik.typ"

  #doc
]

