# Mündliche Prüfungen Mathematik

Dieser Fragebogen gibt den KommilitonInnen, die nach Dir die Prüfung ablegen
wollen, einen Einblick in Ablauf und Inhalt der Prüfung. Das erleichtert die
Vorbereitung.

Für Informationen zu dem Textsatzsystem Typst am besten in die [Dokumentation](https://typst.app/docs/)
schauen.

Die Vorlagen werden [hier](https://source.orangerot.dev/university/vorlagen-muendliche-pruefungen) entwickelt.

## Nutzung

Es ist der Typst-Compiler nötig. Dieser ist für eine vielzahl an Betriebssystemen
verfügbar.

Zum Erstellen des Dokumentes müssen lediglich die Argumente in der Datei
`main.typ` ausgefüllt werden.

```typst
#import "lib.typ": exam-report, event, KIND

#show: exam-report.with(
  study: "",                                 // Studiengang
  lecture: "",                               // Fach
  kind: KIND.NONE,                           // Prüfungsart KIND.{DIPLOM, STAATSEXAM, STUDIENBEGLEITEND, BACHELOR, MASTER}
  date: datetime(year: 0, month: 1, day: 1), // Prüfungsdatum
  examiner: "",                              // PrüferIn (Prof)
  grade_received: 0.0,                       // Note
  grade_reasonable: "",                      // War die Note angemessen?
  exam_duration: duration(minutes: 0),       // Prüfungsdauer
  checked_knowledge_gaps: none,              // Wurde Unwissen abgeprüft?
  attendance: (
    /* Titel der Vorlesung, Dozent, Wann gehört, SWS, ECTS, LP */
    event(name: "", lecturer: "", semester: "", sws: "", ects: "", lp: ""),
    event(name: "", lecturer: "", semester: "", sws: "", ects: "", lp: ""),
    event(name: "", lecturer: "", semester: "", sws: "", ects: "", lp: ""),
    event(name: "", lecturer: "", semester: "", sws: "", ects: "", lp: ""),
    event(name: "", lecturer: "", semester: "", sws: "", ects: "", lp: ""),
  ),
  attendance_worth: [
    // Wie regelmäßig hast du die Lehrveranstaltungen besucht? Hat sich der
    // Besuch/Nichtbesuch in der Prüfung positiv/negativ ausgewirkt?
    // Hier ist Platz für deinen Kommentar:
  ],
  literature: [
    // Welche Literatur hast du benutzt (Bücher, Skripten, Vorlesungsmitschriften)?
    // Hier ist Platz für deinen Kommentar:
  ],
  preparation_time: [
    // Hast du dich alleine/zu mehreren auf die Prüfung vorbereitet? Wie lange?
    // Hat es etwas gebracht?
    // Hier ist Platz für deinen Kommentar:
  ],
  agreements: [
    // Fanden vor der Prüfung Absprachen statt (Form, Inhalt, ...)?
    // Wenn ja, welche? Wurden sie eingehalten?
    // Hier ist Platz für deinen Kommentar:
  ],
  preparations: [
    // Welche Tipps zur Vorbereitung kannst du geben?
    // (wichtige/unwichtige Teile des Stoffs, gute Literatur, Lernstil)
    // Hier ist Platz für deinen Kommentar:
  ],
  examiner_behavior: [
    // Was kannst du zum Prüfungsstil des/der Prüfenden sagen?
    // (Prüfungsatmosphäre, (un)klare Fragestellungen, Fragen nach Einzelheiten
    // oder eher größere Zusammenhänge, gezielte Zwischenfragen oder lässt
    // er/sie dich erzählen, Weiterhelfen bei Unsicherheiten ...)
    // Hier ist Platz für deinen Kommentar:
  ],
  examiner_recommendation: (none, [
    // Kannst du die Prüfenden weiterempfehlen?
    // Hier ist Platz für deinen Kommentar:
  ]),
  examinee_behavior: [
    // Welche Ratschläge für das Verhalten in der Prüfung kannst du geben?
    // Hier ist Platz für deinen Kommentar:
  ],
)

// Schreibe bitte möglichst viele Fragen und Antworten auf.
// Hier ist Platz für deinen Kommentar:
```

Um den Fragebogen schlussendlich zu bauen führt man folgenden Befehl aus:
```sh
typst compile main.typ
```

Für Personen, welche in die Struktur des Dokuments eintauchen wollen gibt es die
Datei `muendliche-pruefung-mathematik.typ`. Diese ist der Inspiration in TeX vom
Aufbau ähnlich. Das befüllen des Fragebogens ist hier etwas schwerer, weil erst
die richtige Stelle im Code gefunden werden muss.

Um die Änderungen direkt beim Speichern zu sehen, kann man folgenden Befehl
nutzen:
```sh
typst watch muendliche-pruefung.typ
```

## Hintergrund

Diese Vorlage ist stark Inspiriert von der [Protokollvorlage mündliche Prüfung
(TeX)](https://legacy.fsmi.org/Pruefungen/Vorlagen/Info/muendlich-neu.tar.gz)
von der Liste an [Protokollvorlagen](https://www.fsmi.org/studium/pruefungen/muendliche-pruefungen/#protokoll-vorlagen)
der Fachschaft Mathematik/Informatik des KIT.

Bei der Erstellung der Vorlage wurde darauf geachtet, dass die PDF-Ausgabe von
Typst möglichst ähnlich zu der PDF-Ausgabe der Inspiration in TeX ist. Dabei
werden diverse Layoutelemente von Typst verwendet, welche das Layout mit Tabellen in
TeX ersetzen.

## Lizenz

Das Projekt steht unter der MIT Lizenz.

```
MIT License

Copyright (c) 2025 Gero Beckmann <orangerot@orangerot.dev>

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
```

Die Dateien `muendliche-pruefung-mathematik.typ` und `main.typ` stehen unter der
MIT No Attribution Lizenz (MIT-0).

```
MIT No Attribution

Copyright (c) 2025 Gero Beckmann <orangerot@orangerot.dev>

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
```

Das Logo der Fachschaft Mathematik/Informatik (FSMI) des KIT wird in diesem
Projekt verwendet und ist deren urheberrechtliches Eigentum. Alle Rechte liegen
bei der FSMI. Die Nutzung gilt nur in den von der FSMI festgelegten Bedingugen.

## Kontakt

Gero Beckmann - orangerot@orangerot.dev

Projekt: https://source.orangerot.dev/university/vorlagen-muendliche-pruefungen

