#set page("a4", margin: 1.1cm, footer: context if counter(page).get() == (1,) [#h(1fr)$arrow.r.hook$ *Rückseite bitte nicht vergessen!*])
#set text(lang: "de", size: 10pt)
#set grid(column-gutter: .5cm, inset: (bottom: 10pt))
#set table(stroke: 0.5pt)
#show emoji.hand.write: box(height: 10pt, clip: true, scale(x:-100%)[🖎])
#let radiobox(checked: false) = if checked {$circle.filled$} else {$circle$}
#let input(width: 1fr, name: "", body) = box(width: width, height: 1em, inset: (bottom: 2pt), baseline: 2pt, stroke: (bottom: (dash: "loosely-dotted")),align(right, [#body #label(name)]))
#let question(name: "", question, body) = [
  #grid(columns: 2, inset: 0pt, emoji.hand.write, box(inset: (top: 3pt))[*#question*])

  #body #label(name)
]

#grid(columns: 2 * (1fr,),
  [
    #v(1em)
    #grid(columns: 2,
    image(width: 1.8cm, "fsmi-logo.svg"),
    text(size: 15pt)[
      Fragebogen der Fachschaft zu
      *mündlichen Prüfungen* \
      im Informatikstudium
    ])
  ],
  [],
  [],
  [
    #align(center)[Barcode:]
  ],
  par(justify: true)[
    Dieser Fragebogen gibt den Studierenden, die nach dir die Prüfung ablegen
    wollen, einen Einblick in Ablauf und Inhalt der Prüfung. Das erleichtert die
    Vorbereitung. \
    Bitte verwende zum Ausfüllen einen schwarzen Stift. Das erleichtert das
    Einscannen. \
    Vielen Dank für deine Mitarbeit!
  ],
  [
    #grid(
      columns: (.1cm, 1fr, .1cm),
      rows:    (.1cm, 2.5cm, .1cm),
      stroke: (x,y) => (:
      top:    if x != 1 and y == 0 {.5pt},
      bottom: if x != 1 and y == 2 {.5pt},
      left:   if y != 1 and x == 0 {.5pt},
      right:  if y != 1 and x == 2 {.5pt},
    ))
    #v(2em)
  ],
  [
    Dein Studiengang: #input(name: "study")[
      // Hier ist Platz für deinen Kommentar.
    ]

    Prüfungsart: \
    #[
      #radiobox(checked: false) Wahlpflicht \
      #radiobox(checked: false) Vertiefungsfach \
      #radiobox(checked: false) Ergänzungsfach  \
    ] <kind>

    Welches? #input(name: "lecture")[
      // Hier ist Platz für deinen Kommentar.
    ]
  ],
  [
    #grid(columns: (auto, 1fr),
      [Prüfungsdatum:],
      input(name: "date")[
        // Hier ist Platz für deinen Kommentar.
      ],
      [Prüfer(in):],
      input(name: "examiner")[
        // Hier ist Platz für deinen Kommentar.
      ],
      [Beisitzer(in):],
      input(name: "assistant")[
        // Hier ist Platz für deinen Kommentar.
      ],
    )
  ],
)

*Prüfungsfächer und Vorbereitung:*

#table(columns: 4 * (1fr,), row-gutter: (2pt, ..(3*(0pt,))), rows: 2em, align: horizon,
  table.header(
    [Veranstaltung],[Dozent(in)],[Jahr],[regelmäßig besucht?]),
    [             ],[          ],[    ],[                   ],
    [             ],[          ],[    ],[                   ],
    [             ],[          ],[    ],[                   ],
    [             ],[          ],[    ],[                   ],
) <attendance>

#v(1em)
#grid(columns: 2 * (1fr,),
  [
    Note:
    #input(name: "grade_received")[
      // Hier ist Platz für deinen Kommentar.
    ]
  ],
  [
    Prüfungsdauer:
    #input(name: "exam_duration")[
      // Hier ist Platz für deinen Kommentar.
    ] Minuten
  ],
)

#v(1em)
War diese Note angemessen?
#input(name: "grade_reasonable")[
  // Hier ist Platz für deinen Kommentar.
]

#v(1em)
#question(name: "examiner_behavior")[
  Wie war der Prüfungsstil des Prüfers / der Prüferin?
][
  Prüfungsatmosphäre, (un)klare Fragestellungen, Frage nach Einzelheiten oder
  eher größeren Zusammenhängen, kamen häufiger Zwi- schenfragen oder ließ er/sie
  dich erzählen, wurde dir weitergeholfen, wurde in Wissenslücken gebohrt?

  // Hier ist Platz für deinen Kommentar.
]

#pagebreak()

#grid(rows: (3 * (22em,)), columns: 2 * (1fr,),
  question(name: "attendance_worth")[
    Hat sich der Besuch / Nichtbesuch der Veran- staltung für dich gelohnt?
  ][
    // Hier ist Platz für deinen Kommentar.
  ],
  question(name: "examiner_recommendations")[
    Kannst du ihn / sie weiterempfehlen? Warum?
  ][
    #radiobox(checked: false) Ja \
    #radiobox(checked: false) Nein

    // Hier ist Platz für deinen Kommentar.
  ],
  question(name: "preparation_time")[
    Wie lange und wie hast du dich alleine oder mit anderen auf die Prüfung vorbereitet?
  ][
    // Hier ist Platz für deinen Kommentar.
  ],
  question(name: "agreements")[
    Fanden vor der Prüfung Absprachen zu Form oder Inhalt statt? Wurden sie eingehalten?
  ][
    // Hier ist Platz für deinen Kommentar.
  ],
  question(name: "preparations")[
    Welche Tipps zur Vorbereitung kannst du ge-\ ben?
  ][
    Wichtige / unwichtige Teile des Stoffes, gute Bücher / Skrip- ten, Lernstil, ...

    // Hier ist Platz für deinen Kommentar.
  ],
  question(name: "examinee_behavior")[
    Kannst du Ratschläge für das Verhalten in der Prüfung geben?
  ][
    // Hier ist Platz für deinen Kommentar.
  ],
)

*Inhalte der Prüfung (bitte auf weitere Blätter):*

#[
  #set list(spacing: 1.2em, indent: 1.5em)
  - Schreibe bitte möglichst viele Fragen und Antworten auf.
  - Wo wurde nach Herleitungen oder Beweisen gefragt oder sonstwie nachgehakt?
  - Worauf wollte der Prüfer / die Prüferin hinaus?
  - Welche Fragen gehörten nicht zum eigentlichen Stoff?
]

#colbreak()

// Hier ist Platz für deinen Kommentar.

