// SPDX-FileCopyrightText: 2025 Gero Beckmann <orangerot@orangerot.dev>
//
// SPDX-License-Identifier: MIT

#let KIND = (:
  "WAHLPFLICHT":     "Wahlpflicht",
  "VERTIEFUNGSFACH": "Vertiefungsfach",
  "ERGAENZUNGSFACH": "Ergänzungsfach",
  "NONE":            ""
)

#let event(name: "", lecturer: "", semester: "", did_attend: "") = (
  name, lecturer, semester, did_attend
)

#let exam-report(
  study: "",                                 // Studiengang
  lecture: "",                               // Fach
  kind: KIND.NONE,                           // Prüfungsart KIND.{WAHLPFLICHT, VERTIEFUNGSFACH, ERGAENZUNGSFACH}
  date: datetime(year: 0, month: 1, day: 1), // Prüfungsdatum
  examiner: "",                              // PrüferIn (Prof)
  assistant: "",                             // BeisitzerIn
  grade_received: 0.0,                       // Note
  grade_reasonable: "",                      // War die Note angemessen?
  exam_duration: duration(minutes: 0),       // Prüfungsdauer
  attendance: (
  /* Veranstaltung, Dozent(in), Jahr, regelmäßig besucht? */
    event(name: "", lecturer: "", semester: "", did_attend: ""),
    event(name: "", lecturer: "", semester: "", did_attend: ""),
    event(name: "", lecturer: "", semester: "", did_attend: ""),
    event(name: "", lecturer: "", semester: "", did_attend: ""),
  ),
  attendance_worth: [
    // Hat sich der Besuch / Nichtbesuch der Veranstaltung für dich gelohnt?
  ],
  preparation_time: [
    // Wie lange und wie hast du dich alleine oder mit anderen auf die Prüfung vorbereitet?
  ],
  agreements: [
    // Fanden vor der Prüfung Absprachen zu Form oder Inhalt statt? Wurden sie eingehalten?
  ],
  preparations: [
    // Welche Tipps zur Vorbereitung kannst du geben?
  ],
  examiner_behavior: [
    // Wie war der Prüfungsstil des Prüfers / der Prüferin?
  ],
  examiner_recommendation: (none, [          // true, false
    // Kannst du ihn / sie weiterempfehlen? Warum?
  ]),
  examinee_behavior: [
    // Kannst Du Ratschläge für das Verhalten in der Prüfung geben?
  ],
  doc
) = [
  #let radiobox(checked: false) = if checked {$circle.filled$} else {$circle$}

  #show <study>: study
  #show <lecture>: lecture
  #show <date>: if date.year() > 0 {date.display("[day].[month].[year]")}
  #show <examiner>: examiner
  #show <assistant>: assistant
  #show <grade_received>: if grade_received > 0.0 {str(grade_received+0.01).slice(0,3).replace(".",",")}
  #show <grade_reasonable>: grade_reasonable
  #show <exam_duration>: if exam_duration.minutes() > 0 [#exam_duration.minutes()]
  #show <attendance_worth>: attendance_worth
  #show <preparation_time>: preparation_time
  #show <agreements>: agreements
  #show <preparations>: it => [#it #preparations]
  #show <examiner_behavior>: it => [#it #examinee_behavior]
  #show <examinee_behavior>: examiner_behavior
  #show <kind>: {
    for exam_kind in KIND.values().filter(it => it != KIND.NONE) [
      #radiobox(checked: kind == exam_kind) #exam_kind \
    ]
  }
  #show <examiner_recommendations>: [
    #let can_recommend = examiner_recommendation.at(0)
    #radiobox(checked: can_recommend == true) Ja \
    #radiobox(checked: can_recommend == false) Nein

    #examiner_recommendation.at(1)
  ]
  #show <attendance>: it => {
    let g = it.fields()
    let _ = g.remove("children")
    let _ = g.remove("label")

    table(..g,
      ..it.fields().children.at(0).children,
      ..(attendance + 4*(event(),)).slice(0,4).flatten()
    )
  }

  #include "muendliche-pruefung.typ"

  #doc
]

