#set page("a4", margin: (top: 1cm, bottom: 0cm, rest: 1.55cm))
#set text(lang: "de", size: 10.5pt)
#set par(justify: true, leading: .5em, spacing: 0.5em)
#set block(spacing: 0pt)
#set table(inset: (top: 2pt, bottom: 4pt, x: 8pt), stroke: .5pt)
#set grid(inset: (y: 3pt, x: 6pt))
#set grid.vline(stroke: .5pt)
#set linebreak(justify: true)
#let checkbox(checked: false) = if (checked) {$times.square$} else {$square$}
#let input(width: 1fr, name: "", body) = box(width: width, inset: (bottom: 2pt), baseline: 2pt, stroke: (bottom: (dash: "dotted")),align(right, [#body #label(name)]))
#let textarea(name: "", body) = [#body #label(name)]
#show emoji.pencil: "✎"

#grid(columns: (2cm, 15cm), align: bottom,
  box(inset: (x: 3pt), image(width: 1.3cm, "fsmi-logo.svg")),
  [
    #set text(size: 15pt)
    #set par(spacing: 3pt)
    Fragebogen der Fachschaft zu

    *mündlichen Vordiplomsprüfungen* im Informatikstudium
  ]
)

#grid(columns: 2*(1fr,), grid.vline(x:1),
  [
    Dieser Fragebogen gibt den KommilitonInnen, die nach
    Dir die Prüfung ablegen wollen, einen Einblick in Ab-
    lauf und Inhalt der Prüfung. Das erleichtert die Vorbe-
    reitung.

    Bitte verwende zum Ausfüllen einen schwarzen Stift.

    Das erleichtert das Einscannen.

    #box(height: 2em, align(bottom)[
      *Prüfungsdatum:*#input(name: "date")[
        // Hier ist Platz für deinen Kommentar.
      ]
    ])
    #box(height: 2em, align(bottom)[
      *PrüferIn (Prof.):*#input(name: "examiner")[
        // Hier ist Platz für deinen Kommentar.
      ]
    ])
    #box(height: 2em, align(bottom)[
      *BeisitzerIn:*#input(name: "assistant")[
        // Hier ist Platz für deinen Kommentar.
      ]
    ])
  ],
  [
    #block(width: 7cm, inset: (top: 1.5em, bottom: .3cm, rest: .2cm), align(center,
    [
      Barcode: #v(2pt)
      #grid(
        columns: (.1cm, 7.8cm, .1cm),
        rows:    (.1cm, 2.5cm, .1cm),
        stroke: (x,y) => (:
        top:    if (x != 1 and y == 0) {.5pt},
        bottom: if (x != 1 and y == 2) {.5pt},
        left:   if (y != 1 and x == 0) {.5pt},
        right:  if (y != 1 and x == 2) {.5pt},
      ))
    ]))
    *Fach:* \
    #set box(height: .5em, inset: (left: 5pt))
    #textarea(name: "lecture", {
      // box[#checkbox(checked: true) Dein Fach]
      box[#checkbox() Algo I]
      box[#checkbox() Algo II]
      box[#checkbox() Betriebssysteme]
      box[#checkbox() GdI]
      box[#checkbox() HM]
      box[#checkbox() KomDat]
      box[#checkbox() Programmierparadigmen]
      box[#checkbox() SWT I]
      box[#checkbox() Theoretische Grundlagen der Informatik]
      box[#checkbox() TI]
    })
  ]
)

#table(columns: (7.4cm,2.4cm,8.2cm), rows: (auto, ..3*(1.7em,)), table.header(
  [Veranstaltung],[Jahr],[regelmäßig besucht?]),
  [*Vorlesung*  ],[    ],[                   ],
  [*Übung*      ],[    ],[                   ],
  [*Tutorium*   ],[    ],[                   ],
) <attendance>

#grid(columns: 2*(1fr,), inset: (y: .5cm), grid.vline(x:1),
  textarea(name: "did_pass")[
    *Bestanden?
    #checkbox(checked: false) Ja /
    #checkbox(checked: false) Nein*
  ],
  box(width: 6cm)[
    *Prüfungsdauer: #input(name: "exam_duration")[
      // Hier ist Platz für deinen Kommentar.
    ]
    Minuten*
  ]
)
#grid(columns: 2*(1fr,), rows: (3.5cm,2.8cm,7.3cm), grid.vline(x:1),
  [
    #emoji.pencil Wie lange und wie hast Du Dich \
    #underline[alleine bzw. mit anderen vorbereitet]?
    #textarea(name: "preparation_time")[
      // Hier ist Platz für deinen Kommentar.
    ]
  ],
  grid.cell(rowspan: 2)[
    #emoji.pencil Welche #underline[Tips zur Vorbereitung] kannst Du geben? \
    #text(size: 8.5pt)[(Wichtige / Unwichtige Teile des Stoffes, gute Bücher / Skripten, Lernstil)]
    #textarea(name: "preparations")[
      // Hier ist Platz für deinen Kommentar.
    ]
  ],
  [
    #emoji.pencil Fanden vor der Prüfung #underline[Absprachen] zu Form oder
    Inhalt statt? Wurden sie #underline[eingehalten]?
    #textarea(name: "agreements")[
      // Hier ist Platz für deinen Kommentar.
    ]
  ],
  [
    #emoji.pencil Kannst Du Ratschläge für das \ #underline[Verhalten in der Prüfung] geben?
    #textarea(name: "examinee_behavior")[
      // Hier ist Platz für deinen Kommentar.
    ]
  ],
  [
    #emoji.pencil Wie war der #underline[Prüfungsstil des Prüfers / der Prüferin?] \
    #text(size: 8.5pt)[
      (Prüfungsathmosphäre, (un)klare Fragestellungen, Fragen nach \
      Einzelheiten oder eher größeren Zusammenhängen, kamen häufiger
      Zwischenfragen oder ließ er/sie Dich erzählen, wurde Dir weitergeholfen,
      wurde in Wissenslücken gebohrt?)
    ]
    #textarea(name: "examiner_behavior")[
      // Hier ist Platz für deinen Kommentar.
    ]
  ]
)
#line(length: 100%, stroke: .5pt)
#v(2pt)
#text(size: 13pt)[*Inhalte der Prüfung:*] $-->$ Bitte auf die Rückseite und weitere Blätter!
#v(1.2em)

#set list(spacing: 1.2em, indent: 1.5em)
- Schreibe bitte möglichst viele Fragen und Antworten auf.
- Wo wurde nach Herleitungen oder Beweisen gefragt oder sonstwie nachgehakt?
- Worauf wollte der Prüfer / die Prüferin hinaus?
- Welche Fragen gehörten nicht zum eigentlichen Stoff?

#colbreak()
// Hier ist Platz für deinen Kommentar.

