// SPDX-FileCopyrightText: 2025 Gero Beckmann <orangerot@orangerot.dev>
//
// SPDX-License-Identifier: MIT

#let event(name: "", semester: "", did_attend: "") = (
  strong(name), semester, did_attend
)

#let exam-report(
  lecture: "",                               // Fach
  date: datetime(year: 0, month: 1, day: 1), // Prüfungsdatum
  examiner: "",                              // PrüferIn (Prof)
  assistant: "",                             // BeisitzerIn
  did_pass: none,                            // Bestanden? true || false
  exam_duration: duration(minutes: 0),       // Prüfungsdauer
  attendance: (
    /* Veranstaltung, Jahr, regelmäßig besucht? */
    event(name: "Vorlesung", semester: "", did_attend: ""),
    event(name: "Übung",     semester: "", did_attend: ""),
    event(name: "Tutorium",  semester: "", did_attend: ""),
  ),
  preparation_time: [
    // Wie lange und wie hast Du Dich alleine bzw. mit anderen vorbereitet?
  ],
  agreements: [
    // Fanden vor der Prüfung Absprachen zu Form oder Inhalt statt? Wurden sie eingehalten?
  ],
  preparations: [
    // Welche Tips zur Vorbereitung kannst Du geben?
  ],
  examiner_behavior: [
    // Wie war der Prüfungsstil des Prüfers / der Prüferin?
  ],
  examinee_behavior: [
    // Kannst Du Ratschläge für das Verhalten in der Prüfung geben?
  ],
  doc
) = [
  #let checkbox(checked: false) = if (checked) {$times.square$} else {$square$}

  #show <date>: if date.year() > 0 {date.display("[day].[month].[year]")}
  #show <examiner>: examiner
  #show <assistant>: assistant
  #show <exam_duration>: if exam_duration.minutes() > 0 [#exam_duration.minutes()]
  #show <preparation_time>: preparation_time
  #show <agreements>: agreements
  #show <preparations>: preparations
  #show <examinee_behavior>: examinee_behavior
  #show <examiner_behavior>: examiner_behavior
  #show <did_pass>: [
    *Bestanden?
    #checkbox(checked: did_pass == true) Ja /
    #checkbox(checked: did_pass == false) Nein*
  ]
  #show <lecture>: it => if lecture.len() > 0 {
    box[#checkbox(checked: true) #lecture]
  } else {it}
  #show <attendance>: it => {
    let g = it.fields()
    let _ = g.remove("children")
    let _ = g.remove("label")
    table(..g,
      ..it.fields().children.at(0).children,
      ..(attendance + 3*(event(),)).slice(0,3).flatten()
    )
  }

  #include "muendliche-nachpruefung.typ"

  #doc
]

