# Vorlage mündliche Nachprüfung (3. Versuch) in Typst

Dieser Fragebogen gibt den KommilitonInnen, die nach Dir die Prüfung ablegen
wollen, einen Einblick in Ablauf und Inhalt der Prüfung. Das erleichtert die
Vorbereitung.

Für Informationen zu dem Textsatzsystem Typst am besten in die
[Dokumentation](https://typst.app/docs/)
schauen.

Die Vorlagen werden [hier](https://source.orangerot.dev/university/vorlagen-muendliche-pruefungen) entwickelt.

## Nutzung

Es ist der Typst-Compiler nötig. Dieser ist für eine vielzahl an Betriebssystemen
verfügbar.

Die Vorlage enthält zwei Optionen den Fragebogen zu erstellen. Empfohlen ist das
Erstellen mit Template. Dafür müssen lediglich die Argumente in der Datei
`main.typ` ausgefüllt werden.
```typst
#import "lib.typ": exam-report, event

#show: exam-report.with(
  lecture: "",                               // Fach
  date: datetime(year: 0, month: 1, day: 1), // Prüfungsdatum
  examiner: "",                              // PrüferIn (Prof)
  assistant: "",                             // BeisitzerIn
  did_pass: none,                            // Bestanden? true || false
  exam_duration: duration(minutes: 0),       // Prüfungsdauer
  attendance: (
    /* Veranstaltung, Jahr, regelmäßig besucht? */
    event(name: "Vorlesung", semester: "", did_attend: ""),
    event(name: "Übung",     semester: "", did_attend: ""),
    event(name: "Tutorium",  semester: "", did_attend: ""),
  ),
  preparation_time: [
    // Wie lange und wie hast Du Dich alleine bzw. mit anderen vorbereitet?
    // Hier ist Platz für deinen Kommentar:
  ],
  agreements: [
    // Fanden vor der Prüfung Absprachen zu Form oder Inhalt statt? Wurden sie eingehalten?
    // Hier ist Platz für deinen Kommentar:
  ],
  preparations: [
    // Welche Tips zur Vorbereitung kannst Du geben?
    // Hier ist Platz für deinen Kommentar:
  ],
  examiner_behavior: [
    // Wie war der Prüfungsstil des Prüfers / der Prüferin?
    // Hier ist Platz für deinen Kommentar:
  ],
  examinee_behavior: [
    // Kannst Du Ratschläge für das Verhalten in der Prüfung geben?
    // Hier ist Platz für deinen Kommentar:
  ],
)

// Schreibe bitte möglichst viele Fragen und Antworten auf.
// Hier ist Platz für deinen Kommentar:
```

Um den Fragebogen schlussendlich zu bauen
führt man folgenden Befehl aus:
```sh
typst compile main.typ
```

Für Personen, welche in die Struktur des Dokuments eintauchen wollen gibt es die
Datei `muendliche-nachpruefung.typ`. Diese ist der Inspiration in TeX vom Aufbau
ähnlich. Das befüllen des Fragebogens ist hier etwas schwerer, weil erst die
richtige Stelle im Code gefunden werden muss.

Um die Änderungen direkt beim Speichern zu sehen, kann man folgenden Befehl
nutzen:
```sh
typst watch muendliche-nachpruefung.typ
```

## Hintergrund

Diese Vorlage ist stark Inspiriert von der
[Protokollvorlage Nachprüfung (TeX)](https://legacy.fsmi.org/Pruefungen/Vorlagen/Info/bachelor.tgz)
von der
Liste an
[Protokollvorlagen](https://www.fsmi.org/studium/pruefungen/muendliche-pruefungen/#protokoll-vorlagen)
der Fachschaft Mathematik/Informatik des KIT.

Bei der Erstellung der Vorlage wurde darauf geachtet, dass die PDF-Ausgabe von
Typst möglichst ähnlich zu der PDF-Ausgabe der Inspiration in TeX ist. Dabei
werden diverse Layoutelemente von Typst verwendet, welche das Layout mit Tabellen in
TeX ersetzen.

## Lizenz

Das Projekt steht unter der MIT Lizenz.

```
MIT License

Copyright (c) 2025 Gero Beckmann <orangerot@orangerot.dev>

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
```

Die Dateien `muendliche-nachpruefung.typ` und `main.typ` stehen unter der
MIT No Attribution Lizenz (MIT-0).

```
MIT No Attribution

Copyright (c) 2025 Gero Beckmann <orangerot@orangerot.dev>

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
```

Das Logo der Fachschaft Mathematik/Informatik (FSMI) des KIT wird in diesem
Projekt verwendet und ist deren urheberrechtliches Eigentum. Alle Rechte liegen
bei der FSMI. Die Nutzung gilt nur in den von der FSMI festgelegten Bedingugen.

## Kontakt

Gero Beckmann - orangerot@orangerot.dev

Projekt: https://source.orangerot.dev/university/vorlagen-muendliche-pruefungen

